#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include scripts\utility;
#include maps\mp\gametypes\common_sd_sr;
#include maps\mp\gametypes\sd;
#include maps\mp\gametypes\_gamelogic;

init(){
    precachemodel( "equip_iw4_throwingknife_npc" );
    replacefunc(maps\mp\gametypes\_weapons::throwingknifeusage, ::autoPickupThrowingKnife);
    replacefunc(maps\mp\gametypes\_menus::menugiveclass, ::mef_menugiveclass);

    level thread user_scripts\mp_patches\ph\game::init();
}

autoPickupThrowingKnife(){
	self endon("death");
	self endon("disconnect");
	for(;;){
		self waittill("grenade_fire", grenade, weaponName);
        if(isdefined(grenade) && weaponName == "iw9_throwknife_mp"){
            grenade thread waitForStick();
        }
	}
}

waitForStick(){
	self waittill("missile_stuck");
	oldOrigin = undefined;
	while(self.origin != oldOrigin){
        oldOrigin = self.origin;
        wait 1;
    }
	pos = self.origin;
	model = spawn( "script_model", pos );
	model setModel("equip_iw4_throwingknife_npc");
	model.angles = self.angles;
	trigger = spawn( "trigger_radius", pos-(0,0,45), 0, 30, 50 );
	trigger thread watchTimeout(model);
	self delete();
	while(isdefined(trigger))
	{
		trigger waittill( "trigger", player );
		if(Distance(pos, player getTagOrigin("j_head")) <= 75 && player hasWeapon("iw9_throwknife_mp") && player getammocount("iw9_throwknife_mp") == 0)
		{
			player setlethalweapon("iw9_throwknife_mp");
			player maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
			player setWeaponAmmoClip("iw9_throwknife_mp", 1);
			player playLocalSound("h2_scavenger_pack_pickup");
			trigger notify("deleted");
			model delete();
			trigger delete();
		}
		wait 0.025;
	}
}

watchTimeout(model){
	self endon("deleted");
	wait 60;
	model delete();
	self delete();
}

mef_menugiveclass( var_0 )
{
    
}


mef_onstartgametype()
{
    if ( !isdefined( game["switchedsides"] ) )
        game["switchedsides"] = 0;

    if ( game["switchedsides"] )
    {
        var_0 = game["attackers"];
        var_1 = game["defenders"];
        game["attackers"] = var_1;
        game["defenders"] = var_0;
    }

    setclientnamemode( "manual_change" );
    //maps\mp\gametypes\common_bomb_gameobject::loadbombfx();
    //maps\mp\_utility::setobjectivetext( game["attackers"], &"OBJECTIVES_SD_ATTACKER" );
    //maps\mp\_utility::setobjectivetext( game["defenders"], &"OBJECTIVES_SD_DEFENDER" );
    /*
    if ( level.splitscreen )
    {
        maps\mp\_utility::setobjectivescoretext( game["attackers"], &"OBJECTIVES_SD_ATTACKER" );
        maps\mp\_utility::setobjectivescoretext( game["defenders"], &"OBJECTIVES_SD_DEFENDER" );
    }
    else
    {
        maps\mp\_utility::setobjectivescoretext( game["attackers"], &"OBJECTIVES_SD_ATTACKER_SCORE" );
        maps\mp\_utility::setobjectivescoretext( game["defenders"], &"OBJECTIVES_SD_DEFENDER_SCORE" );
    }
    */
    //maps\mp\_utility::setobjectivehinttext( game["attackers"], &"OBJECTIVES_SD_ATTACKER_HINT" );
    //maps\mp\_utility::setobjectivehinttext( game["defenders"], &"OBJECTIVES_SD_DEFENDER_HINT" );
    initspawns();
    var_2[0] = "sd";
    var_2[1] = "bombzone";
    var_2[2] = "blocker";
    maps\mp\gametypes\_gameobjects::main( var_2 );
    thread maps\mp\gametypes\common_sd_sr::updategametypedvars();
    maps\mp\_utility::setcarrierloadouts();
    thread maps\mp\gametypes\common_sd_sr::bombs();
    thread maps\mp\gametypes\_spectating::allowallyteamspectating();
}

mef_bombs()
{
    level.bombplanted = 0;
    level.bombdefused = 0;
    level.bombexploded = 0;
    var_0 = getent( "sd_bomb_pickup_trig", "targetname" );

    if ( !isdefined( var_0 ) )
    {
        common_scripts\utility::error( "No sd_bomb_pickup_trig trigger found in map." );
        return;
    }

    var_1 = maps\mp\gametypes\common_bomb_gameobject::getcarrybombvisuals( "sd_bomb" );

    if ( !isdefined( var_1 ) )
    {
        common_scripts\utility::error( "No sd_bomb script_model found in map." );
        return;
    }

    if ( !level.multibomb )
    {
        //level.sdbomb = maps\mp\gametypes\common_bomb_gameobject::createbombcarryobject( game["attackers"], "friendly", var_0, var_1 );
        //thread maps\mp\_utility::streamcarrierweaponstoplayers( level.sdbomb, [ game["attackers"] ], ::shouldstreamcarrierclasstoplayer );

        //if ( game["attackers"] == "allies" )
        //    maps\mp\_utility::setmlgicons( level.sdbomb, "waypoint_bomb_green" );
        //else
        //    maps\mp\_utility::setmlgicons( level.sdbomb, "waypoint_bomb_red" );

        //level.sdbomb.onpickup = ::onpickup;
        //level.sdbomb.ondrop = ::ondrop;
    }
    else
    {
        var_0 delete();
        var_1[0] delete();
    }

    level.bombzones = [];
    var_2 = getentarray( "bombzone", "targetname" );
    var_3 = getentarray( "bombzone_augmented", "targetname" );

    if ( maps\mp\_utility::isaugmentedgamemode() )
    {
        for ( var_4 = 0; var_4 < var_3.size; var_4++ )
        {
            var_5 = var_3[var_4].script_label;

            for ( var_6 = 0; var_6 < var_2.size; var_6++ )
            {
                if ( var_2[var_6].script_label == var_5 )
                {
                    removebombzone( var_2[var_6] );
                    break;
                }
            }
        }
    }
    else
    {
        for ( var_7 = 0; var_7 < var_3.size; var_7++ )
            removebombzone( var_3[var_7] );
    }

    var_2 = common_scripts\utility::array_combine( var_2, var_3 );

    for ( var_7 = 0; var_7 < var_2.size; var_7++ )
    {
        var_0 = var_2[var_7];
        var_1 = getentarray( var_2[var_7].target, "targetname" );
        var_8 = undefined;

        if ( !level.multibomb )
            var_8 = level.sdbomb;

        //var_9 = maps\mp\gametypes\common_bomb_gameobject::createbombzoneobject( game["defenders"], "enemy", "any", var_0, var_8, 1 );
        var_9 = undefined;
        maps\mp\_utility::setmlgicons( var_9, "waypoint_esports_snd_target" + var_9.label + "_white" );
        var_9.onbeginuse = ::onbeginuse;
        var_9.onenduse = ::onenduse;
        var_9.onuse = ::onuseplantobject;
        var_9.oncantuse = ::oncantuse;
        level.bombzones[level.bombzones.size] = var_9;
        var_9.bombdefusetrig = getent( var_1[0].target, "targetname" );
        var_9.bombdefusetrig.origin += ( 0.0, 0.0, -10000.0 );
        var_9.bombdefusetrig.label = var_9.label;
        var_9.bombdefusetrig usetriggertouchcheckstance( 1 );
    }

    for ( var_7 = 0; var_7 < level.bombzones.size; var_7++ )
    {
        var_10 = [];

        for ( var_11 = 0; var_11 < level.bombzones.size; var_11++ )
        {
            if ( var_11 != var_7 )
                var_10[var_10.size] = level.bombzones[var_11];
        }

        level.bombzones[var_7].otherbombzones = var_10;
    }

    setomnvar( "ui_mlg_game_mode_status_1", 0 );
}